package com.ejie.ab18a.utilidades;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


/**
 * The Class Y46jSentenciaOracle.
 * @author XXXX
 */
public class Ab18aSentenciaOracle {
	
	/**
	 * Instantiates a new y46j sentencia oracle.
	 */
	private Ab18aSentenciaOracle()
	{
		
	}
	
	private static String nombre_clase = "Y46SentenciaOracle";

	/**
	 * Ejecutar pstmt.
	 *
	 * @param pstmt the pstmt
	 * @return the int
	 * @throws Ab18aException the y46j exception
	 */
	public static int ejecutarPSTMT(PreparedStatement pstmt) throws Ab18aException {
		String nombre_metodo = "ejecutarPSTMT";
		int noOfRows = 0;
		try {
			noOfRows = pstmt.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
			noOfRows = -1;
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, e);
		}
		return noOfRows;
	}
	
	/**
	 * Ejecutar pstmt.
	 *
	 * @param pstmt the pstmt
	 * @param noLanzarError the no lanzar error
	 * @return the int
	 * @throws Ab18aException the y46j exception
	 */
	public static int ejecutarPSTMT(PreparedStatement pstmt, boolean noLanzarError) throws Ab18aException {
		String nombre_metodo = "ejecutarPSTMT";
		int noOfRows = 0;
		try {
			noOfRows = pstmt.executeUpdate();
		} catch (Exception e) {
			//e.printStackTrace();
			noOfRows = -1;
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, e);
		}
		return noOfRows;
	}
	
	/**
	 * Ejecutar pstm twith key.
	 *
	 * @param pstmt the pstmt
	 * @return the int
	 * @throws Ab18aException the y46j exception
	 */
	public static int ejecutarPSTMTwithKey(PreparedStatement pstmt) throws Ab18aException {
		String nombre_metodo = "ejecutarPSTMT";
		int key = 0;
		try {
			int noOfRows = pstmt.executeUpdate();
			ResultSet rs = pstmt.getGeneratedKeys();
		    rs.next();
		    key = rs.getInt(1);
			if (noOfRows < 1)
				throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, "No se ha insertado ninguna fila");
		} catch (Exception e) {
			e.printStackTrace();
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, e);
		}
		return key;
	}
	
	/**
	 * Consultar pstmt.
	 *
	 * @param pstmt the pstmt
	 * @return the result set
	 * @throws Ab18aException the y46j exception
	 */
	public static ResultSet consultarPSTMT(PreparedStatement pstmt) throws Ab18aException {
		String nombre_metodo = "consultarPSTMT";
		ResultSet rs = null;
		try {
			rs = pstmt.executeQuery();
		} catch (Exception e) {
			rs = null;
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, e);
		}
		return rs;
	}
	
	/**
	 * Cerrar pstmt.
	 *
	 * @param pstmt the pstmt
	 * @throws Ab18aException the y46j exception
	 */
	public static void cerrarPSTMT(PreparedStatement pstmt) throws Ab18aException {
		String nombre_metodo = "cerrarPSTMT";
		try {
			if (pstmt != null) {
				pstmt.close();
			}
		} catch (SQLException sqle) {
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, sqle);
		}
	}
	
	/**
	 * Cerrar rs.
	 *
	 * @param rs the rs
	 * @throws Ab18aException the y46j exception
	 */
	public static void cerrarRS(ResultSet rs) throws Ab18aException {
		String nombre_metodo = "cerrarRS";
		try {
			if (rs != null){
				rs.close();
			}
		} catch (SQLException sqle) {
			throw new Ab18aException(Ab18aSentenciaOracle.nombre_clase, nombre_metodo, sqle);
		}
	}
}

